<?php
require_once 'includes/config.php';

// Check admin authentication
session_start();
$is_admin_logged_in = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;

if (!$is_admin_logged_in) {
    // Handle admin login
    $error = '';
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $username = sanitizeInput($_POST['username']);
        $password = $_POST['password'];
        
        if ($username === 'admin' && $password === 'Umar3490.') {
            $_SESSION['admin_logged_in'] = true;
            header('Location: admin.php');
            exit();
        } else {
            $error = 'Invalid admin credentials';
        }
    }
    
    // Show login form
    include 'admin/login.php';
    exit();
}

// Admin is logged in, show dashboard
$pdo = getDBConnection();

// Get statistics
$stats = [];

// Total users
$stmt = $pdo->query("SELECT COUNT(*) as count FROM users WHERE is_banned = 0");
$stats['total_users'] = $stmt->fetch()['count'];

// Banned users
$stmt = $pdo->query("SELECT COUNT(*) as count FROM users WHERE is_banned = 1");
$stats['banned_users'] = $stmt->fetch()['count'];

// Total posts
$stmt = $pdo->query("SELECT COUNT(*) as count FROM posts");
$stats['total_posts'] = $stmt->fetch()['count'];

// Featured posts
$stmt = $pdo->query("SELECT COUNT(*) as count FROM posts WHERE is_featured = 1");
$stats['featured_posts'] = $stmt->fetch()['count'];

// Open tickets
$stmt = $pdo->query("SELECT COUNT(*) as count FROM support_tickets WHERE status = 'open'");
$stats['open_tickets'] = $stmt->fetch()['count'];

// Verification requests
$stmt = $pdo->query("SELECT COUNT(*) as count FROM users WHERE verification_requested = 1 AND is_verified = 0");
$stats['verification_requests'] = $stmt->fetch()['count'];

// Get WhatsApp link
$stmt = $pdo->prepare("SELECT setting_value FROM admin_settings WHERE setting_key = 'whatsapp_link'");
$stmt->execute();
$whatsapp_link = $stmt->fetch()['setting_value'] ?? '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Show U</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/admin.css">
</head>
<body class="admin-body">
    <div class="admin-container">
        <header class="admin-header">
            <h1>Show U Admin Panel</h1>
            <div class="admin-actions">
                <span class="admin-user">Welcome, Admin</span>
                <a href="admin.php?logout=1" class="logout-btn">Logout</a>
            </div>
        </header>
        
        <nav class="admin-nav">
            <a href="#dashboard" class="nav-link active" data-section="dashboard">Dashboard</a>
            <a href="#users" class="nav-link" data-section="users">Users</a>
            <a href="#posts" class="nav-link" data-section="posts">Posts</a>
            <a href="#tickets" class="nav-link" data-section="tickets">Support Tickets</a>
            <a href="#verification" class="nav-link" data-section="verification">Verification</a>
            <a href="#settings" class="nav-link" data-section="settings">Settings</a>
        </nav>
        
        <main class="admin-content">
            <!-- Dashboard Section -->
            <section id="dashboard" class="admin-section active">
                <h2>Dashboard Overview</h2>
                <div class="stats-grid">
                    <div class="stat-card">
                        <h3><?php echo $stats['total_users']; ?></h3>
                        <p>Active Users</p>
                    </div>
                    <div class="stat-card">
                        <h3><?php echo $stats['banned_users']; ?></h3>
                        <p>Banned Users</p>
                    </div>
                    <div class="stat-card">
                        <h3><?php echo $stats['total_posts']; ?></h3>
                        <p>Total Posts</p>
                    </div>
                    <div class="stat-card">
                        <h3><?php echo $stats['featured_posts']; ?></h3>
                        <p>Featured Posts</p>
                    </div>
                    <div class="stat-card">
                        <h3><?php echo $stats['open_tickets']; ?></h3>
                        <p>Open Tickets</p>
                    </div>
                    <div class="stat-card">
                        <h3><?php echo $stats['verification_requests']; ?></h3>
                        <p>Verification Requests</p>
                    </div>
                </div>
                
                <div class="recent-activity">
                    <h3>Recent Activity</h3>
                    <div id="recentActivity">Loading...</div>
                </div>
            </section>
            
            <!-- Users Section -->
            <section id="users" class="admin-section">
                <h2>User Management</h2>
                <div class="section-controls">
                    <input type="text" id="userSearch" placeholder="Search users..." class="search-input">
                    <select id="userFilter" class="filter-select">
                        <option value="all">All Users</option>
                        <option value="active">Active Users</option>
                        <option value="banned">Banned Users</option>
                        <option value="verified">Verified Users</option>
                    </select>
                </div>
                <div id="usersTable">Loading users...</div>
            </section>
            
            <!-- Posts Section -->
            <section id="posts" class="admin-section">
                <h2>Post Management</h2>
                <div class="section-controls">
                    <input type="text" id="postSearch" placeholder="Search posts..." class="search-input">
                    <select id="postFilter" class="filter-select">
                        <option value="all">All Posts</option>
                        <option value="featured">Featured Posts</option>
                        <option value="images">Images Only</option>
                        <option value="videos">Videos Only</option>
                    </select>
                </div>
                <div id="postsTable">Loading posts...</div>
            </section>
            
            <!-- Support Tickets Section -->
            <section id="tickets" class="admin-section">
                <h2>Support Tickets</h2>
                <div class="section-controls">
                    <select id="ticketFilter" class="filter-select">
                        <option value="all">All Tickets</option>
                        <option value="open">Open Tickets</option>
                        <option value="closed">Closed Tickets</option>
                    </select>
                </div>
                <div id="ticketsTable">Loading tickets...</div>
            </section>
            
            <!-- Verification Section -->
            <section id="verification" class="admin-section">
                <h2>User Verification</h2>
                <div id="verificationTable">Loading verification requests...</div>
            </section>
            
            <!-- Settings Section -->
            <section id="settings" class="admin-section">
                <h2>Settings</h2>
                <div class="settings-form">
                    <h3>WhatsApp Link Management</h3>
                    <form id="whatsappForm">
                        <div class="form-group">
                            <label for="whatsappLink">Official WhatsApp Link:</label>
                            <input type="url" id="whatsappLink" value="<?php echo htmlspecialchars($whatsapp_link); ?>" 
                                   placeholder="https://wa.me/1234567890" class="form-input">
                        </div>
                        <button type="submit" class="btn btn-primary">Update WhatsApp Link</button>
                    </form>
                </div>
            </section>
        </main>
    </div>
    
    <!-- Modals -->
    <div id="userModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>User Details</h3>
                <button class="close-modal">&times;</button>
            </div>
            <div class="modal-body" id="userModalBody">
                <!-- User details will be loaded here -->
            </div>
        </div>
    </div>
    
    <div id="ticketModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Support Ticket</h3>
                <button class="close-modal">&times;</button>
            </div>
            <div class="modal-body" id="ticketModalBody">
                <!-- Ticket details will be loaded here -->
            </div>
        </div>
    </div>
    
    <script src="assets/js/admin.js"></script>
</body>
</html>

<?php
// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: admin.php');
    exit();
}
?>
