<?php
require_once '../../includes/config.php';

// Check admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

try {
    $pdo = getDBConnection();
    
    // Build query based on filters
    $where_conditions = [];
    $params = [];
    
    if (!empty($search)) {
        $where_conditions[] = "(p.content LIKE ? OR u.username LIKE ? OR u.full_name LIKE ?)";
        $search_term = '%' . $search . '%';
        $params[] = $search_term;
        $params[] = $search_term;
        $params[] = $search_term;
    }
    
    switch ($filter) {
        case 'featured':
            $where_conditions[] = "p.is_featured = 1";
            break;
        case 'images':
            $where_conditions[] = "p.media_type = 'image'";
            break;
        case 'videos':
            $where_conditions[] = "p.media_type = 'video'";
            break;
    }
    
    $where_clause = !empty($where_conditions) ? 'WHERE ' . implode(' AND ', $where_conditions) : '';
    
    // Get posts
    $stmt = $pdo->prepare("
        SELECT p.*, u.username, u.full_name, u.profile_picture, u.is_verified
        FROM posts p 
        JOIN users u ON p.user_id = u.id 
        $where_clause
        ORDER BY p.created_at DESC 
        LIMIT ? OFFSET ?
    ");
    
    $params[] = $limit;
    $params[] = $offset;
    $stmt->execute($params);
    $posts = $stmt->fetchAll();
    
    // Get total count
    $count_params = array_slice($params, 0, -2);
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM posts p JOIN users u ON p.user_id = u.id $where_clause");
    $stmt->execute($count_params);
    $total = $stmt->fetch()['total'];
    
    echo json_encode([
        'success' => true,
        'posts' => $posts,
        'total' => $total,
        'page' => $page,
        'total_pages' => ceil($total / $limit)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
