<?php
require_once '../../includes/config.php';

// Check admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';

try {
    $pdo = getDBConnection();
    
    $where_clause = '';
    if ($filter === 'open') {
        $where_clause = "WHERE t.status = 'open'";
    } elseif ($filter === 'closed') {
        $where_clause = "WHERE t.status = 'closed'";
    }
    
    $stmt = $pdo->prepare("
        SELECT t.*, u.username, u.full_name, u.profile_picture
        FROM support_tickets t 
        JOIN users u ON t.user_id = u.id 
        $where_clause
        ORDER BY t.created_at DESC
    ");
    $stmt->execute();
    $tickets = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'tickets' => $tickets
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
