<?php
require_once '../../includes/config.php';

// Check admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

try {
    $pdo = getDBConnection();
    
    // Build query based on filters
    $where_conditions = [];
    $params = [];
    
    if (!empty($search)) {
        $where_conditions[] = "(username LIKE ? OR full_name LIKE ? OR email LIKE ?)";
        $search_term = '%' . $search . '%';
        $params[] = $search_term;
        $params[] = $search_term;
        $params[] = $search_term;
    }
    
    switch ($filter) {
        case 'active':
            $where_conditions[] = "is_banned = 0";
            break;
        case 'banned':
            $where_conditions[] = "is_banned = 1";
            break;
        case 'verified':
            $where_conditions[] = "is_verified = 1";
            break;
    }
    
    $where_clause = !empty($where_conditions) ? 'WHERE ' . implode(' AND ', $where_conditions) : '';
    
    // Get users
    $stmt = $pdo->prepare("
        SELECT id, username, full_name, email, profile_picture, is_verified, is_banned, 
               followers_count, following_count, posts_count, created_at
        FROM users 
        $where_clause
        ORDER BY created_at DESC 
        LIMIT ? OFFSET ?
    ");
    
    $params[] = $limit;
    $params[] = $offset;
    $stmt->execute($params);
    $users = $stmt->fetchAll();
    
    // Get total count
    $count_params = array_slice($params, 0, -2); // Remove limit and offset
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM users $where_clause");
    $stmt->execute($count_params);
    $total = $stmt->fetch()['total'];
    
    echo json_encode([
        'success' => true,
        'users' => $users,
        'total' => $total,
        'page' => $page,
        'total_pages' => ceil($total / $limit)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
