<?php
require_once '../../includes/config.php';

// Check admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';
$post_id = (int)($input['post_id'] ?? 0);

if (!$post_id || !$action) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    switch ($action) {
        case 'feature':
            $stmt = $pdo->prepare("UPDATE posts SET is_featured = 1 WHERE id = ?");
            $stmt->execute([$post_id]);
            echo json_encode(['success' => true, 'message' => 'Post featured successfully']);
            break;
            
        case 'unfeature':
            $stmt = $pdo->prepare("UPDATE posts SET is_featured = 0 WHERE id = ?");
            $stmt->execute([$post_id]);
            echo json_encode(['success' => true, 'message' => 'Post unfeatured successfully']);
            break;
            
        case 'delete':
            // Get post info for file deletion
            $stmt = $pdo->prepare("SELECT media_url, user_id FROM posts WHERE id = ?");
            $stmt->execute([$post_id]);
            $post = $stmt->fetch();
            
            if ($post) {
                // Delete post from database
                $stmt = $pdo->prepare("DELETE FROM posts WHERE id = ?");
                $stmt->execute([$post_id]);
                
                // Update user's post count
                $stmt = $pdo->prepare("UPDATE users SET posts_count = posts_count - 1 WHERE id = ?");
                $stmt->execute([$post['user_id']]);
                
                // Delete media file
                if (file_exists($post['media_url'])) {
                    unlink($post['media_url']);
                }
                
                echo json_encode(['success' => true, 'message' => 'Post deleted successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Post not found']);
            }
            break;
            
        default:
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
