<?php
require_once '../../includes/config.php';

// Check admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$ticket_id = (int)($input['ticket_id'] ?? 0);
$reply = trim($input['reply'] ?? '');

if (!$ticket_id || empty($reply)) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("UPDATE support_tickets SET admin_reply = ?, status = 'closed' WHERE id = ?");
    $stmt->execute([$reply, $ticket_id]);
    
    echo json_encode(['success' => true, 'message' => 'Reply sent and ticket closed']);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
