<?php
require_once '../../includes/config.php';

// Check admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';
$user_id = (int)($input['user_id'] ?? 0);

if (!$user_id || !$action) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    switch ($action) {
        case 'ban':
            $stmt = $pdo->prepare("UPDATE users SET is_banned = 1 WHERE id = ?");
            $stmt->execute([$user_id]);
            echo json_encode(['success' => true, 'message' => 'User banned successfully']);
            break;
            
        case 'unban':
            $stmt = $pdo->prepare("UPDATE users SET is_banned = 0 WHERE id = ?");
            $stmt->execute([$user_id]);
            echo json_encode(['success' => true, 'message' => 'User unbanned successfully']);
            break;
            
        case 'delete_posts':
            $stmt = $pdo->prepare("DELETE FROM posts WHERE user_id = ?");
            $stmt->execute([$user_id]);
            
            // Update user's post count
            $stmt = $pdo->prepare("UPDATE users SET posts_count = 0 WHERE id = ?");
            $stmt->execute([$user_id]);
            
            echo json_encode(['success' => true, 'message' => 'User posts deleted successfully']);
            break;
            
        case 'verify':
            $stmt = $pdo->prepare("UPDATE users SET is_verified = 1, verification_requested = 0 WHERE id = ?");
            $stmt->execute([$user_id]);
            echo json_encode(['success' => true, 'message' => 'User verified successfully']);
            break;
            
        case 'unverify':
            $stmt = $pdo->prepare("UPDATE users SET is_verified = 0 WHERE id = ?");
            $stmt->execute([$user_id]);
            echo json_encode(['success' => true, 'message' => 'User verification removed']);
            break;
            
        default:
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
