<?php
require_once '../../includes/config.php';

// Check admin authentication
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$whatsapp_link = trim($input['whatsapp_link'] ?? '');

if (empty($whatsapp_link) || !filter_var($whatsapp_link, FILTER_VALIDATE_URL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid WhatsApp link']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("UPDATE admin_settings SET setting_value = ? WHERE setting_key = 'whatsapp_link'");
    $stmt->execute([$whatsapp_link]);
    
    echo json_encode(['success' => true, 'message' => 'WhatsApp link updated successfully']);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
