<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$post_id = isset($input['post_id']) ? (int)$input['post_id'] : 0;
$comment = isset($input['comment']) ? trim($input['comment']) : '';
$user_id = $_SESSION['user_id'];

if (!$post_id || empty($comment)) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit();
}

if (strlen($comment) > 500) {
    echo json_encode(['success' => false, 'message' => 'Comment too long (max 500 characters)']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    // Add comment
    $stmt = $pdo->prepare("INSERT INTO comments (user_id, post_id, comment) VALUES (?, ?, ?)");
    $stmt->execute([$user_id, $post_id, $comment]);
    
    // Update post comments count
    $stmt = $pdo->prepare("UPDATE posts SET comments_count = comments_count + 1 WHERE id = ?");
    $stmt->execute([$post_id]);
    
    // Get user info for the response
    $stmt = $pdo->prepare("SELECT username, full_name, profile_picture FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    
    echo json_encode([
        'success' => true,
        'comment' => [
            'id' => $pdo->lastInsertId(),
            'comment' => htmlspecialchars($comment),
            'username' => $user['username'],
            'full_name' => $user['full_name'],
            'profile_picture' => $user['profile_picture'],
            'created_at' => date('Y-m-d H:i:s')
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
