<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

$post_id = isset($_GET['post_id']) ? (int)$_GET['post_id'] : 0;

if (!$post_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid post ID']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("
        SELECT c.*, u.username, u.full_name, u.profile_picture, u.is_verified
        FROM comments c 
        JOIN users u ON c.user_id = u.id 
        WHERE c.post_id = ? 
        ORDER BY c.created_at ASC
    ");
    $stmt->execute([$post_id]);
    $comments = $stmt->fetchAll();
    
    // Format comments for display
    $formatted_comments = array_map(function($comment) {
        return [
            'id' => $comment['id'],
            'comment' => htmlspecialchars($comment['comment']),
            'username' => $comment['username'],
            'full_name' => $comment['full_name'],
            'profile_picture' => $comment['profile_picture'],
            'is_verified' => $comment['is_verified'],
            'time_ago' => timeAgo($comment['created_at'])
        ];
    }, $comments);
    
    echo json_encode([
        'success' => true,
        'comments' => $formatted_comments
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
