<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

$other_user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
$last_message_id = isset($_GET['last_id']) ? (int)$_GET['last_id'] : 0;
$current_user_id = $_SESSION['user_id'];

if (!$other_user_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid user ID']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    // Get new messages since last_message_id
    $stmt = $pdo->prepare("
        SELECT * FROM messages 
        WHERE ((sender_id = ? AND receiver_id = ?) OR (sender_id = ? AND receiver_id = ?))
        AND id > ?
        ORDER BY created_at ASC
    ");
    $stmt->execute([$current_user_id, $other_user_id, $other_user_id, $current_user_id, $last_message_id]);
    $messages = $stmt->fetchAll();
    
    // Mark received messages as read
    if (!empty($messages)) {
        $stmt = $pdo->prepare("UPDATE messages SET is_read = 1 WHERE sender_id = ? AND receiver_id = ? AND id > ?");
        $stmt->execute([$other_user_id, $current_user_id, $last_message_id]);
    }
    
    // Format messages
    $formatted_messages = array_map(function($message) use ($current_user_id) {
        return [
            'id' => $message['id'],
            'message' => htmlspecialchars($message['message']),
            'sender_id' => $message['sender_id'],
            'is_sent' => $message['sender_id'] == $current_user_id,
            'timestamp' => date('H:i', strtotime($message['created_at'])),
            'created_at' => $message['created_at']
        ];
    }, $messages);
    
    echo json_encode([
        'success' => true,
        'messages' => $formatted_messages
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
