<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

$query = isset($_GET['q']) ? trim($_GET['q']) : '';
$current_user_id = $_SESSION['user_id'];

if (strlen($query) < 2) {
    echo json_encode(['success' => true, 'users' => []]);
    exit();
}

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("
        SELECT id, username, full_name, profile_picture, is_verified
        FROM users 
        WHERE (username LIKE ? OR full_name LIKE ?) 
        AND id != ? AND is_banned = 0
        ORDER BY full_name ASC
        LIMIT 20
    ");
    $search_term = '%' . $query . '%';
    $stmt->execute([$search_term, $search_term, $current_user_id]);
    $users = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'users' => $users
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
