<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$receiver_id = isset($input['receiver_id']) ? (int)$input['receiver_id'] : 0;
$message = isset($input['message']) ? trim($input['message']) : '';
$sender_id = $_SESSION['user_id'];

if (!$receiver_id || empty($message) || $receiver_id == $sender_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit();
}

if (strlen($message) > 1000) {
    echo json_encode(['success' => false, 'message' => 'Message too long (max 1000 characters)']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    // Check if receiver exists and is not banned
    $stmt = $pdo->prepare("SELECT id FROM users WHERE id = ? AND is_banned = 0");
    $stmt->execute([$receiver_id]);
    if (!$stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'User not found']);
        exit();
    }
    
    // Insert message
    $stmt = $pdo->prepare("INSERT INTO messages (sender_id, receiver_id, message) VALUES (?, ?, ?)");
    $stmt->execute([$sender_id, $receiver_id, $message]);
    
    $message_id = $pdo->lastInsertId();
    
    echo json_encode([
        'success' => true,
        'message_id' => $message_id,
        'timestamp' => date('H:i')
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
