<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$target_user_id = isset($input['user_id']) ? (int)$input['user_id'] : 0;
$current_user_id = $_SESSION['user_id'];

if (!$target_user_id || $target_user_id == $current_user_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid user ID']);
    exit();
}

try {
    $pdo = getDBConnection();
    
    // Check if already following
    $stmt = $pdo->prepare("SELECT id FROM follows WHERE follower_id = ? AND following_id = ?");
    $stmt->execute([$current_user_id, $target_user_id]);
    $existing_follow = $stmt->fetch();
    
    if ($existing_follow) {
        // Unfollow
        $stmt = $pdo->prepare("DELETE FROM follows WHERE follower_id = ? AND following_id = ?");
        $stmt->execute([$current_user_id, $target_user_id]);
        
        // Update follower count
        $stmt = $pdo->prepare("UPDATE users SET followers_count = followers_count - 1 WHERE id = ?");
        $stmt->execute([$target_user_id]);
        
        // Update following count
        $stmt = $pdo->prepare("UPDATE users SET following_count = following_count - 1 WHERE id = ?");
        $stmt->execute([$current_user_id]);
        
        $action = 'unfollowed';
    } else {
        // Follow
        $stmt = $pdo->prepare("INSERT INTO follows (follower_id, following_id) VALUES (?, ?)");
        $stmt->execute([$current_user_id, $target_user_id]);
        
        // Update follower count
        $stmt = $pdo->prepare("UPDATE users SET followers_count = followers_count + 1 WHERE id = ?");
        $stmt->execute([$target_user_id]);
        
        // Update following count
        $stmt = $pdo->prepare("UPDATE users SET following_count = following_count + 1 WHERE id = ?");
        $stmt->execute([$current_user_id]);
        
        $action = 'followed';
    }
    
    // Get updated counts
    $stmt = $pdo->prepare("SELECT followers_count, following_count FROM users WHERE id = ?");
    $stmt->execute([$target_user_id]);
    $target_user = $stmt->fetch();
    
    echo json_encode([
        'success' => true,
        'action' => $action,
        'followers_count' => $target_user['followers_count']
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}
?>
