document.addEventListener("DOMContentLoaded", () => {
  // Initialize profile tabs
  initializeProfileTabs()

  // Initialize follow button
  initializeFollowButton()

  // Initialize post thumbnails
  initializePostThumbnails()
})

function initializeProfileTabs() {
  const tabButtons = document.querySelectorAll(".tab-btn")
  const tabContents = document.querySelectorAll(".tab-content")

  tabButtons.forEach((button) => {
    button.addEventListener("click", () => {
      const tabName = button.dataset.tab

      // Remove active class from all tabs and contents
      tabButtons.forEach((btn) => btn.classList.remove("active"))
      tabContents.forEach((content) => content.classList.remove("active"))

      // Add active class to clicked tab and corresponding content
      button.classList.add("active")
      document.getElementById(`${tabName}-tab`).classList.add("active")
    })
  })
}

function initializeFollowButton() {
  const followBtn = document.querySelector(".follow-btn")
  if (!followBtn) return

  followBtn.addEventListener("click", function () {
    const userId = this.dataset.userId
    const isFollowing = this.classList.contains("following")

    // Optimistic UI update
    if (isFollowing) {
      this.classList.remove("following")
      this.classList.add("btn-primary")
      this.textContent = "Follow"
    } else {
      this.classList.add("following")
      this.classList.remove("btn-primary")
      this.textContent = "Following"
    }

    // Disable button during request
    this.disabled = true

    fetch("api/toggle-follow.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify({ user_id: userId }),
    })
      .then((response) => response.json())
      .then((data) => {
        if (data.success) {
          // Update follower count
          const followerCount = document.querySelector(".stat-number")
          if (followerCount) {
            followerCount.textContent = data.followers_count
          }
        } else {
          // Revert optimistic update on error
          if (isFollowing) {
            this.classList.add("following")
            this.classList.remove("btn-primary")
            this.textContent = "Following"
          } else {
            this.classList.remove("following")
            this.classList.add("btn-primary")
            this.textContent = "Follow"
          }
          alert(data.message || "Failed to update follow status")
        }
      })
      .catch((error) => {
        console.error("Error:", error)
        // Revert optimistic update on error
        if (isFollowing) {
          this.classList.add("following")
          this.classList.remove("btn-primary")
          this.textContent = "Following"
        } else {
          this.classList.remove("following")
          this.classList.add("btn-primary")
          this.textContent = "Follow"
        }
        alert("Failed to update follow status. Please try again.")
      })
      .finally(() => {
        this.disabled = false
      })
  })
}

function initializePostThumbnails() {
  const postThumbnails = document.querySelectorAll(".post-thumbnail")

  postThumbnails.forEach((thumbnail) => {
    thumbnail.addEventListener("click", function () {
      const postId = this.dataset.postId
      // TODO: Open post in modal or navigate to post detail page
      console.log("Open post:", postId)
      // For now, redirect to dashboard
      window.location.href = "dashboard.php"
    })
  })
}
