<?php
require_once 'includes/config.php';
requireLogin();

$user = getCurrentUser();
$pdo = getDBConnection();

// Get recent posts for feed
$stmt = $pdo->prepare("
    SELECT p.*, u.username, u.full_name, u.profile_picture, u.is_verified,
           (SELECT COUNT(*) FROM likes WHERE post_id = p.id) as likes_count,
           (SELECT COUNT(*) FROM comments WHERE post_id = p.id) as comments_count,
           (SELECT COUNT(*) FROM likes WHERE post_id = p.id AND user_id = ?) as user_liked
    FROM posts p 
    JOIN users u ON p.user_id = u.id 
    WHERE u.is_banned = 0
    ORDER BY p.created_at DESC 
    LIMIT 20
");
$stmt->execute([$user['id']]);
$posts = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home - Show U</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="main-container">
        <header class="header">
            <h1>Show U</h1>
        </header>
        
        <div class="content">
            <div class="welcome-section">
                <h2>Welcome back, <?php echo htmlspecialchars($user['full_name']); ?>!</h2>
                <p>Share your moments with the world</p>
            </div>
            
            <div class="create-post-btn">
                <a href="pages/create-post.php" class="btn btn-primary">Create New Post</a>
            </div>
            
            <div class="posts-feed">
                <?php if (empty($posts)): ?>
                    <div class="no-posts">
                        <p>No posts yet. Be the first to share something!</p>
                    </div>
                <?php else: ?>
                    <?php foreach ($posts as $post): ?>
                        <div class="post-card" data-post-id="<?php echo $post['id']; ?>">
                            <div class="post-header">
                                <img src="uploads/profiles/<?php echo htmlspecialchars($post['profile_picture']); ?>" 
                                     alt="Profile" class="profile-pic">
                                <div class="post-user-info">
                                    <h4><?php echo htmlspecialchars($post['full_name']); ?>
                                        <?php if ($post['is_verified']): ?>
                                            <span class="verified-badge">✓</span>
                                        <?php endif; ?>
                                    </h4>
                                    <span class="username">@<?php echo htmlspecialchars($post['username']); ?></span>
                                    <span class="post-time"><?php echo timeAgo($post['created_at']); ?></span>
                                </div>
                            </div>
                            
                            <?php if ($post['content']): ?>
                                <div class="post-content">
                                    <p><?php echo nl2br(htmlspecialchars($post['content'])); ?></p>
                                </div>
                            <?php endif; ?>
                            
                            <div class="post-media">
                                <?php if ($post['media_type'] == 'image'): ?>
                                    <img src="<?php echo htmlspecialchars($post['media_url']); ?>" 
                                         alt="Post image" class="post-image">
                                <?php else: ?>
                                    <video controls class="post-video">
                                        <source src="<?php echo htmlspecialchars($post['media_url']); ?>" type="video/mp4">
                                    </video>
                                <?php endif; ?>
                            </div>
                            
                            <div class="post-actions">
                                <button class="action-btn like-btn <?php echo $post['user_liked'] ? 'liked' : ''; ?>" 
                                        data-post-id="<?php echo $post['id']; ?>">
                                    <span class="like-icon">♥</span>
                                    <span class="like-count"><?php echo $post['likes_count']; ?></span>
                                </button>
                                
                                <button class="action-btn comment-btn" data-post-id="<?php echo $post['id']; ?>">
                                    <span class="comment-icon">💬</span>
                                    <span class="comment-count"><?php echo $post['comments_count']; ?></span>
                                </button>
                                
                                <button class="action-btn share-btn" data-post-id="<?php echo $post['id']; ?>">
                                    <span class="share-icon">📤</span>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        
        <?php include 'includes/bottom-nav.php'; ?>
    </div>
    
    <script src="assets/js/main.js"></script>
</body>
</html>
