<?php
require_once 'includes/config.php';
requireLogin();

$user = getCurrentUser();
$pdo = getDBConnection();

// Get conversations (users who have exchanged messages)
$stmt = $pdo->prepare("
    SELECT DISTINCT 
        CASE 
            WHEN m.sender_id = ? THEN m.receiver_id 
            ELSE m.sender_id 
        END as other_user_id,
        u.username, u.full_name, u.profile_picture, u.is_verified,
        (SELECT message FROM messages m2 
         WHERE (m2.sender_id = ? AND m2.receiver_id = other_user_id) 
            OR (m2.sender_id = other_user_id AND m2.receiver_id = ?) 
         ORDER BY m2.created_at DESC LIMIT 1) as last_message,
        (SELECT created_at FROM messages m2 
         WHERE (m2.sender_id = ? AND m2.receiver_id = other_user_id) 
            OR (m2.sender_id = other_user_id AND m2.receiver_id = ?) 
         ORDER BY m2.created_at DESC LIMIT 1) as last_message_time,
        (SELECT COUNT(*) FROM messages m2 
         WHERE m2.sender_id = other_user_id AND m2.receiver_id = ? AND m2.is_read = 0) as unread_count
    FROM messages m
    JOIN users u ON u.id = CASE 
        WHEN m.sender_id = ? THEN m.receiver_id 
        ELSE m.sender_id 
    END
    WHERE (m.sender_id = ? OR m.receiver_id = ?) AND u.is_banned = 0
    ORDER BY last_message_time DESC
");
$stmt->execute([$user['id'], $user['id'], $user['id'], $user['id'], $user['id'], $user['id'], $user['id'], $user['id'], $user['id']]);
$conversations = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inbox - Show U</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/inbox.css">
</head>
<body>
    <div class="main-container">
        <header class="header">
            <h1>Messages</h1>
            <button class="new-message-btn" id="newMessageBtn">✉</button>
        </header>
        
        <div class="content">
            <?php if (empty($conversations)): ?>
                <div class="no-conversations">
                    <div class="no-conversations-content">
                        <h3>No messages yet</h3>
                        <p>Start a conversation by visiting someone's profile and sending them a message.</p>
                        <a href="dashboard.php" class="btn btn-primary">Explore Posts</a>
                    </div>
                </div>
            <?php else: ?>
                <div class="conversations-list">
                    <?php foreach ($conversations as $conversation): ?>
                        <div class="conversation-item" data-user-id="<?php echo $conversation['other_user_id']; ?>">
                            <div class="conversation-avatar">
                                <img src="uploads/profiles/<?php echo htmlspecialchars($conversation['profile_picture']); ?>" 
                                     alt="Profile" class="avatar-img">
                                <div class="online-indicator" data-user-id="<?php echo $conversation['other_user_id']; ?>"></div>
                            </div>
                            
                            <div class="conversation-info">
                                <div class="conversation-header">
                                    <h4><?php echo htmlspecialchars($conversation['full_name']); ?>
                                        <?php if ($conversation['is_verified']): ?>
                                            <span class="verified-badge">✓</span>
                                        <?php endif; ?>
                                    </h4>
                                    <span class="message-time"><?php echo timeAgo($conversation['last_message_time']); ?></span>
                                </div>
                                
                                <div class="conversation-preview">
                                    <p class="last-message"><?php echo htmlspecialchars(substr($conversation['last_message'], 0, 50)) . (strlen($conversation['last_message']) > 50 ? '...' : ''); ?></p>
                                    <?php if ($conversation['unread_count'] > 0): ?>
                                        <span class="unread-badge"><?php echo $conversation['unread_count']; ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
        
        <?php include 'includes/bottom-nav.php'; ?>
    </div>
    
    <!-- New Message Modal -->
    <div class="new-message-modal" id="newMessageModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>New Message</h3>
                <button class="close-modal" id="closeNewMessageModal">×</button>
            </div>
            <div class="modal-body">
                <div class="search-users">
                    <input type="text" id="userSearch" placeholder="Search users..." class="search-input">
                    <div class="search-results" id="searchResults"></div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="assets/js/inbox.js"></script>
</body>
</html>
