<?php
require_once '../includes/config.php';
requireLogin();

$current_user = getCurrentUser();
$other_user_id = isset($_GET['user']) ? (int)$_GET['user'] : 0;

if (!$other_user_id || $other_user_id == $current_user['id']) {
    header('Location: ../inbox.php');
    exit();
}

$pdo = getDBConnection();

// Get other user info
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? AND is_banned = 0");
$stmt->execute([$other_user_id]);
$other_user = $stmt->fetch();

if (!$other_user) {
    header('Location: ../inbox.php');
    exit();
}

// Mark messages as read
$stmt = $pdo->prepare("UPDATE messages SET is_read = 1 WHERE sender_id = ? AND receiver_id = ?");
$stmt->execute([$other_user_id, $current_user['id']]);

// Get messages
$stmt = $pdo->prepare("
    SELECT * FROM messages 
    WHERE (sender_id = ? AND receiver_id = ?) OR (sender_id = ? AND receiver_id = ?)
    ORDER BY created_at ASC
");
$stmt->execute([$current_user['id'], $other_user_id, $other_user_id, $current_user['id']]);
$messages = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat with <?php echo htmlspecialchars($other_user['full_name']); ?> - Show U</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/chat.css">
</head>
<body>
    <div class="main-container">
        <header class="chat-header">
            <div class="chat-header-content">
                <a href="../inbox.php" class="back-btn">←</a>
                <div class="chat-user-info">
                    <img src="../uploads/profiles/<?php echo htmlspecialchars($other_user['profile_picture']); ?>" 
                         alt="Profile" class="chat-avatar">
                    <div class="chat-user-details">
                        <h3><?php echo htmlspecialchars($other_user['full_name']); ?>
                            <?php if ($other_user['is_verified']): ?>
                                <span class="verified-badge">✓</span>
                            <?php endif; ?>
                        </h3>
                        <span class="online-status" data-user-id="<?php echo $other_user_id; ?>">Online</span>
                    </div>
                </div>
                <a href="../profile.php?id=<?php echo $other_user_id; ?>" class="profile-btn">👤</a>
            </div>
        </header>
        
        <div class="chat-messages" id="chatMessages">
            <?php if (empty($messages)): ?>
                <div class="no-messages">
                    <p>Start your conversation with <?php echo htmlspecialchars($other_user['full_name']); ?></p>
                </div>
            <?php else: ?>
                <?php foreach ($messages as $message): ?>
                    <div class="message <?php echo $message['sender_id'] == $current_user['id'] ? 'sent' : 'received'; ?>">
                        <div class="message-content">
                            <p><?php echo nl2br(htmlspecialchars($message['message'])); ?></p>
                            <span class="message-time"><?php echo date('H:i', strtotime($message['created_at'])); ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <div class="chat-input-container">
            <form class="chat-form" id="chatForm">
                <input type="hidden" id="receiverId" value="<?php echo $other_user_id; ?>">
                <textarea id="messageInput" placeholder="Type a message..." rows="1" maxlength="1000"></textarea>
                <button type="submit" class="send-btn" id="sendBtn">
                    <span class="send-icon">→</span>
                </button>
            </form>
        </div>
    </div>
    
    <script src="../assets/js/chat.js"></script>
</body>
</html>
