<?php
require_once 'includes/config.php';
requireLogin();

$user = getCurrentUser();
$pdo = getDBConnection();

// Get video posts for shorts feed
$stmt = $pdo->prepare("
    SELECT p.*, u.username, u.full_name, u.profile_picture, u.is_verified,
           (SELECT COUNT(*) FROM likes WHERE post_id = p.id) as likes_count,
           (SELECT COUNT(*) FROM comments WHERE post_id = p.id) as comments_count,
           (SELECT COUNT(*) FROM likes WHERE post_id = p.id AND user_id = ?) as user_liked,
           (SELECT COUNT(*) FROM follows WHERE follower_id = ? AND following_id = p.user_id) as is_following
    FROM posts p 
    JOIN users u ON p.user_id = u.id 
    WHERE p.media_type = 'video' AND u.is_banned = 0
    ORDER BY RAND()
    LIMIT 50
");
$stmt->execute([$user['id'], $user['id']]);
$videos = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shorts - Show U</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/shorts.css">
</head>
<body class="shorts-body">
    <div class="shorts-container">
        <header class="shorts-header">
            <h1>Shorts</h1>
            <a href="pages/create-post.php" class="create-btn">+</a>
        </header>
        
        <div class="shorts-feed" id="shortsContainer">
            <?php if (empty($videos)): ?>
                <div class="no-videos">
                    <div class="no-videos-content">
                        <h3>No videos yet!</h3>
                        <p>Be the first to share a short video</p>
                        <a href="pages/create-post.php" class="btn btn-primary">Create Video</a>
                    </div>
                </div>
            <?php else: ?>
                <?php foreach ($videos as $index => $video): ?>
                    <div class="short-video" data-video-id="<?php echo $video['id']; ?>" data-index="<?php echo $index; ?>">
                        <video 
                            class="video-player" 
                            src="<?php echo htmlspecialchars($video['media_url']); ?>"
                            loop 
                            muted
                            playsinline
                            preload="metadata"
                            <?php echo $index === 0 ? 'autoplay' : ''; ?>
                        ></video>
                        
                        <div class="video-overlay">
                            <div class="video-info">
                                <div class="user-info">
                                    <img src="uploads/profiles/<?php echo htmlspecialchars($video['profile_picture']); ?>" 
                                         alt="Profile" class="user-avatar">
                                    <div class="user-details">
                                        <h4>@<?php echo htmlspecialchars($video['username']); ?>
                                            <?php if ($video['is_verified']): ?>
                                                <span class="verified-badge">✓</span>
                                            <?php endif; ?>
                                        </h4>
                                        <?php if ($video['user_id'] != $user['id']): ?>
                                            <button class="follow-btn-small <?php echo $video['is_following'] ? 'following' : ''; ?>" 
                                                    data-user-id="<?php echo $video['user_id']; ?>">
                                                <?php echo $video['is_following'] ? 'Following' : 'Follow'; ?>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <?php if ($video['content']): ?>
                                    <div class="video-caption">
                                        <p><?php echo nl2br(htmlspecialchars($video['content'])); ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="video-actions">
                                <button class="action-btn like-btn <?php echo $video['user_liked'] ? 'liked' : ''; ?>" 
                                        data-post-id="<?php echo $video['id']; ?>">
                                    <span class="action-icon">♥</span>
                                    <span class="action-count"><?php echo $video['likes_count']; ?></span>
                                </button>
                                
                                <button class="action-btn comment-btn" data-post-id="<?php echo $video['id']; ?>">
                                    <span class="action-icon">💬</span>
                                    <span class="action-count"><?php echo $video['comments_count']; ?></span>
                                </button>
                                
                                <button class="action-btn share-btn" data-post-id="<?php echo $video['id']; ?>">
                                    <span class="action-icon">📤</span>
                                </button>
                                
                                <button class="action-btn profile-btn" onclick="window.location.href='profile.php?id=<?php echo $video['user_id']; ?>'">
                                    <img src="uploads/profiles/<?php echo htmlspecialchars($video['profile_picture']); ?>" 
                                         alt="Profile" class="profile-action-img">
                                </button>
                            </div>
                        </div>
                        
                        <div class="video-controls">
                            <button class="play-pause-btn">
                                <span class="play-icon">▶</span>
                                <span class="pause-icon">⏸</span>
                            </button>
                        </div>
                        
                        <div class="video-progress">
                            <div class="progress-bar">
                                <div class="progress-fill"></div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <?php include 'includes/bottom-nav.php'; ?>
    </div>
    
    <!-- Comments Modal -->
    <div class="comments-modal" id="commentsModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Comments</h3>
                <button class="close-modal" id="closeModal">×</button>
            </div>
            <div class="modal-body">
                <div class="comments-list" id="modalCommentsList">
                    <!-- Comments will be loaded here -->
                </div>
                <form class="comment-form" id="modalCommentForm">
                    <textarea class="comment-input" placeholder="Add a comment..." maxlength="500" rows="1"></textarea>
                    <button type="submit" class="comment-submit">→</button>
                </form>
            </div>
        </div>
    </div>
    
    <script src="assets/js/main.js"></script>
    <script src="assets/js/shorts.js"></script>
</body>
</html>
